GIWIK.init.js(['css','msg']);

HEADING.updateDateTime = function ()
{
	//HEADING.change_state_params();
	
	var d = new Date();

	window.Text_SysDay.setValue((''+(d.getDate())).replace(/(^[0-9]$)/, "0$1"));
	window.Text_SysMonth.setValue((''+(d.getMonth()+1)).replace(/(^[0-9]$)/, "0$1"));
	window.Text_SysYear.setValue(d.getFullYear());

	window.Text_SysHours.setValue((''+(d.getHours())).replace(/(^[0-9]$)/, "0$1"));
	window.Text_SysMinutes.setValue((''+(d.getMinutes())).replace(/(^[0-9]$)/, "0$1"));
	window.Text_SysSeconds.setValue((''+(d.getSeconds())).replace(/(^[0-9]$)/, "0$1"));
};


HEADING.readConf.local = function ()
{
	var year_sys = System_state.SystemTime[0].split("/")[2];	//30/01/2017
	var year_pc = new Date().getFullYear();

	// Si l'heure du système est antérieure à l'année du PC, on part de l'année du système jusqu'à l'année du PC + 10 ans
	if (year_sys < year_pc)
	{
		var _list = make_num_list_zerofill(year_sys,year_pc+10);
		var _num =  _list;

		window.Select_Year.setList(_num, _list);
	}

	window.Select_Day.setValue(System_state.SystemTime[0].split("/")[0]);
	window.Select_Month.setValue(System_state.SystemTime[0].split("/")[1]);
	window.Select_Year.setValue(year_sys);

	window.Select_Hours.setValue(System_state.SystemTime[1].split(":")[0]);		//10:25:35
	window.Select_Minutes.setValue(System_state.SystemTime[1].split(":")[1]);
	window.Select_Seconds.setValue(System_state.SystemTime[1].split(":")[2]);
};

HEADING.getConf.local = function ()
{
	var _params = {};

	_params['SystemTime'] = "";

	return _params;
};

HEADING.sendConf.local = function ()
{
	var _params = {};

	var day;
	var month;
	var year;
	var hours;
	var minutes;
	var seconds;

	if (window.Checkbox_PcClock.getValue() === false)
	{
		day   = window.Select_Day.getValue();
		month = window.Select_Month.getValue();
		year  = window.Select_Year.getValue();

		hours   = window.Select_Hours.getValue();
		minutes = window.Select_Minutes.getValue();
		seconds = window.Select_Seconds.getValue();
	}
	else
	{
		day   = window.Text_SysDay.getValue();
		month = window.Text_SysMonth.getValue();
		year  = window.Text_SysYear.getValue();

		hours   = window.Text_SysHours.getValue();
		minutes = window.Text_SysMinutes.getValue();
		seconds = window.Text_SysSeconds.getValue();
	}

	_params['SystemTime'] = day+"/"+month+"/"+year+","+hours+":"+minutes+":"+seconds;

	return _params;
};

HEADING.construct.local = function ()
{
	var cnt = '',
		_date_format = MSG(['date_format']).split('/');

	select_id0 = 'select_'+_date_format[0];
	select_id1 = 'select_'+_date_format[1];
	select_id2 = 'select_'+_date_format[2];
	text_id0   = 'text_sys'+_date_format[0];
	text_id1   = 'text_sys'+_date_format[1];
	text_id2   = 'text_sys'+_date_format[2];

	cnt += ''
	
	+'<div id="usermsg_alreadysynchronized"></div>'
	+'<div id="checkbox_pcclock"></div>'

	+'<div id="manual_clock_ctnr" class="displaynone">'
		+'<table><tr>'
		+'<td><div id="'+select_id0+'"></div></td>'
		+'<td class="date_separator_sys">/</td>'
		+'<td><div id="'+select_id1+'"></div></td>'
		+'<td class="date_separator_sys">/</td>'
		+'<td><div id="'+select_id2+'"></div></td>'
		+'</tr></table><table><tr>'
		+'<td><div id="select_hours"></div></td>'
		+'<td class="time_separator_sys">:</td>'
		+'<td><div id="select_minutes"></div></td>'
		+'<td class="time_separator_sys">:</td>'
		+'<td><div id="select_seconds"></div></td>'
		+'</tr></table>'
	+'</div>'

	+'<div id="pc_clock_ctnr" class="displaynone">'
		+'<table><tr>'
		+'<td><div id="'+text_id0+'"></div></td>'
		+'<td class="date_separator_pc">/</td>'
		+'<td><div id="'+text_id1+'"></div></td>'
		+'<td class="date_separator_pc">/</td>'
		+'<td><div id="'+text_id2+'"></div></td>'
		+'</tr></table><table><tr>'
		+'<td><div id="text_syshours"></div></td>'
		+'<td class="time_separator_pc">:</td>'
		+'<td><div id="text_sysminutes"></div></td>'
		+'<td class="time_separator_pc">:</td>'
		+'<td><div id="text_sysseconds"></div></td>'
		+'</tr></table>'
	+'</div>';

	$('#content').append(GIWIK.box(cnt, MSG(['box','systemtime_title']),true,[],['','box_content_halfpaddingtop']));

	cnt = null;


	var _num;
	var _list;
	var label;
	var unit;
	var value_step;
	var value_min;
	var value_max;
	HEADING.labels_width = 50;
	HEADING.inputs_width = 38;
	HEADING.inputs_width_text = 22;
	HEADING.inputs_margin_left = 110;

	window.Checkbox_PcClock = new Input_checkbox('Checkbox_PcClock', true);
	window.Checkbox_PcClock.margin_left = HEADING.inputs_margin_left;
	window.Checkbox_PcClock.construct('checkbox_pcclock','linear',MSG(['parameters','synchronise_with_pc_clock']),[false,true],true);
	window.Checkbox_PcClock.setAction("if (window.Checkbox_PcClock.getValue() === true){$('#manual_clock_ctnr').slideUp(200, function(){$('#pc_clock_ctnr').slideDown(200);});}else{$('#pc_clock_ctnr').slideUp(200, function(){$('#manual_clock_ctnr').slideDown(200);});}");
	window.Checkbox_PcClock.setValue(false);
	window.Checkbox_PcClock.show();

	window.Select_Day = new Input_select('Select_Day', true);
	window.Select_Day.label_width = HEADING.labels_width;
	window.Select_Day.input_width = HEADING.inputs_width;
	window.Select_Day.margin_left = (MSG(['date_format']).match(/^dd/)) ? HEADING.inputs_margin_left : 0;
	_list = make_num_list_zerofill(1,31);
	_num =  _list;
	window.Select_Day.construct('select_dd','linear',(MSG(['date_format']).match(/^dd/) ? MSG(['parameters','date']) : ''),_num,_list,'',true);
	window.Select_Day.show();

	window.Select_Month = new Input_select('Select_Month', true);
	window.Select_Month.label_width = HEADING.labels_width;
	window.Select_Month.input_width = HEADING.inputs_width;
	window.Select_Month.margin_left = (MSG(['date_format']).match(/^mm/)) ? HEADING.inputs_margin_left : 0;
	_list = make_num_list_zerofill(1,12);
	_num =  _list;
	window.Select_Month.construct('select_mm','linear',(MSG(['date_format']).match(/^mm/) ? MSG(['parameters','date']) : ''),_num,_list,'',true);
	window.Select_Month.show();

	window.Select_Year = new Input_select('Select_Year', true);
	window.Select_Year.label_width = HEADING.labels_width;
	window.Select_Year.margin_left = (MSG(['date_format']).match(/^yyyy/)) ? HEADING.inputs_margin_left : 0;
	_list = make_num_list_zerofill(new Date().getFullYear(),new Date().getFullYear()+10);
	_num =  _list;
	window.Select_Year.construct('select_yyyy','linear',(MSG(['date_format']).match(/^yyyy/) ? MSG(['parameters','date']) : ''),_num,_list,'',true);
	window.Select_Year.show();


	window.Text_SysDay = new Input_text('Text_SysDay', true);
	window.Text_SysDay.label_width = HEADING.labels_width;
	window.Text_SysDay.input_width = HEADING.inputs_width_text;
	window.Text_SysDay.readonly = true;
	window.Text_SysDay.margin_left = (MSG(['date_format']).match(/^dd/)) ? HEADING.inputs_margin_left : 0;
	window.Text_SysDay.construct('text_sysdd','linear',(MSG(['date_format']).match(/^dd/) ? MSG(['parameters','date']) : ''),'',false);
	window.Text_SysDay.show();

	window.Text_SysMonth = new Input_text('Text_SysMonth', true);
	window.Text_SysMonth.label_width = HEADING.labels_width;
	window.Text_SysMonth.input_width = HEADING.inputs_width_text;
	window.Text_SysMonth.readonly = true;
	window.Text_SysMonth.margin_left = (MSG(['date_format']).match(/^mm/)) ? HEADING.inputs_margin_left : 0;
	window.Text_SysMonth.construct('text_sysmm','linear',(MSG(['date_format']).match(/^mm/) ? MSG(['parameters','date']) : ''),'',false);
	window.Text_SysMonth.show();

	window.Text_SysYear = new Input_text('Text_SysYear', true);
	window.Text_SysYear.label_width = HEADING.labels_width;
	window.Text_SysYear.input_width = HEADING.inputs_width_text*2;
	window.Text_SysYear.readonly = true;
	window.Text_SysYear.margin_left = (MSG(['date_format']).match(/^yyyy/)) ? HEADING.inputs_margin_left : 0;
	window.Text_SysYear.construct('text_sysyyyy','linear',(MSG(['date_format']).match(/^yyyy/) ? MSG(['parameters','date']) : ''),'',false);
	window.Text_SysYear.show();

	window.Select_Hours = new Input_select('Select_Hours', true);
	window.Select_Hours.label_width = HEADING.labels_width;
	window.Select_Hours.input_width = HEADING.inputs_width;
	window.Select_Hours.margin_left = HEADING.inputs_margin_left;
	_list = make_num_list_zerofill(0,23);
	_num =  _list;
	window.Select_Hours.construct('select_hours','linear',MSG(['parameters','time']),_num,_list,'',true);
	window.Select_Hours.show();

	window.Select_Minutes = new Input_select('Select_Minutes', true);
	window.Select_Minutes.input_width = HEADING.inputs_width;
	_list = make_num_list_zerofill(0,59);
	_num =  _list;
	window.Select_Minutes.construct('select_minutes','linear','',_num,_list,'',true);
	window.Select_Minutes.show();

	window.Select_Seconds = new Input_select('Select_Seconds', true);
	window.Select_Seconds.input_width = HEADING.inputs_width;
	_list = make_num_list_zerofill(0,59);
	_num =  _list;
	window.Select_Seconds.construct('select_seconds','linear','',_num,_list,'',true);
	window.Select_Seconds.show();


	window.Text_SysHours = new Input_text('Text_SysHours', true);
	window.Text_SysHours.label_width = HEADING.labels_width;
	window.Text_SysHours.input_width = HEADING.inputs_width_text;
	window.Text_SysHours.margin_left = HEADING.inputs_margin_left;
	window.Text_SysHours.readonly = true;
	window.Text_SysHours.construct('text_syshours','linear',MSG(['parameters','time']),'',false);
	window.Text_SysHours.show();

	window.Text_SysMinutes = new Input_text('Text_SysMinutes', true);
	window.Text_SysMinutes.input_width = HEADING.inputs_width_text;
	window.Text_SysMinutes.readonly = true;
	window.Text_SysMinutes.construct('text_sysminutes','linear','','',false);
	window.Text_SysMinutes.show();

	window.Text_SysSeconds = new Input_text('Text_SysSeconds', true);
	window.Text_SysSeconds.input_width = HEADING.inputs_width_text;
	window.Text_SysSeconds.readonly = true;
	window.Text_SysSeconds.construct('text_sysseconds','linear','','',false);
	window.Text_SysSeconds.show();

	/*
	window.Usermsg_AlreadySynchronized = new User_msg('Usermsg_AlreadySynchronized', true);
	window.Usermsg_AlreadySynchronized.margin = '10px 0 10px 0';
	window.Usermsg_AlreadySynchronized.construct('usermsg_alreadysynchronized', 2, MSG(['parameters','alreadysynchronized']));
	window.Usermsg_AlreadySynchronized.hide();	
	*/
	// Mise en place du timer d'actualisation de l'heure et date du PC client
	window.setInterval("HEADING.updateDateTime();", 200);
};

//Pour activer ou désactiver les objets si le système est synchronisé en temps ou non
/*HEADING.change_state_params = function()
{
	if(System_state.SystemTime[2] === 1)
	{
		$('#manual_clock_cntr').css('opacity',0.5);
		$('#checkbox_pcclock').css('opacity',0.5);
		$('#pc_clock_ctnr').css('opacity',0.5);
		
		window.Checkbox_PcClock.disable();
		window.Select_Day.disable();
		window.Select_Month.disable();
		window.Select_Year.disable();
		window.Select_Hours.disable();
		window.Select_Minutes.disable();
		window.Select_Seconds.disable();
		
		window.Usermsg_AlreadySynchronized.show();			
	}
	else
	{
		$('#manual_clock_cntr').css('opacity',1);
		$('#checkbox_pcclock').css('opacity',1);
		$('#pc_clock_ctnr').css('opacity',1);
		
		window.Checkbox_PcClock.enable();
		window.Select_Day.enable();
		window.Select_Month.enable();
		window.Select_Year.enable();
		window.Select_Hours.enable();
		window.Select_Minutes.enable();
		window.Select_Seconds.enable();
		
		window.Usermsg_AlreadySynchronized.hide();	
	}

};*/